/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.event;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import javax.swing.event.EventListenerList;

public class VWToolbarActionNotifier {
    private EventListenerList m_toolbarActionListeners = null;

    public void addToolbarActionListener(IVWToolbarActionListener listener) {
        if (this.m_toolbarActionListeners == null) {
            this.m_toolbarActionListeners = new EventListenerList();
        }
        this.removeToolbarActionListener(listener);
        this.m_toolbarActionListeners.add(IVWToolbarActionListener.class, listener);
    }

    public void removeToolbarActionListener(IVWToolbarActionListener listener) {
        if (this.m_toolbarActionListeners != null) {
            this.m_toolbarActionListeners.remove(IVWToolbarActionListener.class, listener);
        }
    }

    public void notifyToolbarAction(Object source, int nId) {
        this.notifyToolbarAction(source, nId, null);
    }

    public void notifyToolbarAction(Object source, int nId, Object param) {
        try {
            if (this.m_toolbarActionListeners != null && this.m_toolbarActionListeners.getListenerCount() > 0) {
                VWToolbarActionEvent event = new VWToolbarActionEvent(source, nId, param);
                Object[] listeners = this.m_toolbarActionListeners.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != IVWToolbarActionListener.class) continue;
                    ((IVWToolbarActionListener)listeners[i + 1]).toolbarActionPerformed(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_toolbarActionListeners = null;
    }
}

